
using inetsoftware.Pdfc;
using inetsoftware.Pdfc.Error;
using inetsoftware.Pdfc.Presenter;
using inetsoftware.Pdfc.Results;
using System;
using System.Collections.Generic;
using System.IO;

namespace inetsoftware.PdfcSamples
{
    /// <summary>
    /// A sample for exporting the results of the comparison of 2 PDF Files to a PDF. 
    /// Unlike in the sample SimpleCompareAndExport.cs, in this sample the differences
    /// will be filtered by code after the comparison before starting the export.
    /// 
    /// Expects 2 arguments - the paths of the PDF files to be compared
    /// </summary>
    public class CompareAndExportWithPostDiffFilter
    {
        static CompareAndExportWithPostDiffFilter()
        {
            // Activate the license once from environment if required.
            string key = Environment.GetEnvironmentVariable("PDFC_KEY");
            if (!string.IsNullOrEmpty(key))
            {
                PDFC.ActivateLicense(key);
            }
        }

        /// <summary>
        /// Start the sample, that show how exporting the result of a comparison of 2 PDF Files to a PDF,
        /// showing how to modify the result before starting the export
        /// </summary>
        /// <param name="args">Expects 2 arguments: the paths of the 2 PDF files that will be compared.</param>
        public static void Main(string[] args) {
            if (args == null || args.Length != 2)
            {
                throw new ArgumentException("Usage: <executable> <PDF-File1> <PDF-File2>");
            }

            PDFComparer comparer = new PDFComparer();
            // NOTE: Do not add a presenter to the comparator at this point. Doing so would
            // excute the presneter on the unmodifed result
            using (ResultModel result = comparer.Compare(args[0], args[1]) )
            {
                List<Diff> toHide = new List<Diff>();
                foreach ( Diff diff in result.GetDifferences(false) ) 
                {
                    // Hide all differences where the message contains 'image' for this sample
                    if ( diff.Message.ToLower().Contains("image") )
                    {
                        toHide.Add(diff);
                    }
                }
                // Modify the result. Calling SetDifferencesToHide( null ) cann reverse this modification ir required
                result.SetDifferencesToHide( toHide );

                // Instantiate a PDF export presenter to write the result of the comparison as a PDF file
                DifferencesPDFPresenter differencesPDFPresenter = new DifferencesPDFPresenter(Path.GetDirectoryName(args[0]));
                PresenterExceptionData executionError = differencesPDFPresenter.execute(result);
                if( executionError != null)
                {
                    // Handle the error case and throw an exception if required
                    Console.WriteLine("Error while exporting: " + executionError.GetMessage);
                }
            }
        }
    }
}